package com.hero.objects.perks;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Automaton;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Reputation extends Perk {

	private static String xmlID = "REPUTATION";

	public Reputation(Element root) {
		super(root, Reputation.xmlID);
	}

	@Override
	public double getBaseCost() {
		return baseCost;
	}

	@Override
	public String getColumn2Output() {
		if (getOptions().size() > 0) {
			return getOldColumn2Output();
		}
		String ret = getAlias();
		if ((getName() != null) && (getName().trim().length() > 0)) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		Adder howWell = (Adder) GenericObject.findObjectByID(
				getAssignedAdders(), "HOWWELL");
		Adder howWide = (Adder) GenericObject.findObjectByID(
				getAssignedAdders(), "HOWWIDE");
		howWell.setDisplayInString(false);
		howWide.setDisplayInString(false);
		ret += " (";
		ret += howWide.getSelectedOption().getAlias();
		ret += ")";
		ret += " " + howWell.getSelectedOption().getAlias();
		ret += ", +" + getLevels() + "/+" + getLevels() + "d6";
		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += " (" + adderString + ")";
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public double getLevelCost() {
		if (getOptions().size() > 0) {
			return super.getLevelCost();
		}
		double ret = 0;
		for (int i = 0; i < getAssignedAdders().size(); i++) {
			Adder ad = getAssignedAdders().get(i);
			if (ad.getXMLID().equals("HOWWELL")) {
				ret += ad.getBaseCost();
			} else if (ad.getXMLID().equals("HOWWIDE")) {
				ret += ad.getBaseCost();
			}
		}
		if (ret < 1) {
			ret = 1;
		}
		return ret;
	}

	/**
	 * This is a legacy method for HDv1 characters that have not converted to
	 * the new Reputation.
	 * 
	 * @return
	 */
	public String getOldColumn2Output() {
		String ret = getAlias();
		if ((getName() != null) && (getName().trim().length() > 0)) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		ret += " (";
		ret += getSelectedOption().getAlias();

		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += "; " + adderString;
		}
		ret += ")";
		ret += " +" + getLevels() + "/+" + getLevels() + "d6";
		ret += getModifierString();
		return ret;
	}

	@Override
	public double getTotalCost() {
		double total = getBaseCost();
		if (getLevelValue() != 0) {
			total += getLevels() / getLevelValue() * getLevelCost();
			if (getLevelCost() < getLevelValue()) {
				if ((total > 0) && (total < 1)) {
					total = 1;
				} else {
					total = Rounder.roundHalfDown(total);
				}
			}
		}
		for (Adder ad : getAssignedAdders()) {
			if (ad.isRequired() && !ad.getXMLID().equals("HOWWELL")
					&& !ad.getXMLID().equals("HOWWIDE")) {
				total += ad.getRealCost();
			}
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isRequired() && (ad.getRealCost() > 0)) {
				total += ad.getRealCost();
			}
		}
		if ((total < getMinimumCost()) && isMinSet()) {
			total = getMinimumCost();
		} else if ((total > getMaxCost()) && isMaxSet()) {
			total = getMaxCost();
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isRequired() && (ad.getRealCost() < 0)) {
				total += ad.getRealCost();
			}
		}

		if (getTypes().contains("DEFENSE")
				&& (HeroDesigner.getActiveHero() != null)) {
			if (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
					.getPowers(), "AUTOMATON") != null) {
				Automaton auto = (Automaton) GenericObject.findObjectByID(
						HeroDesigner.getActiveHero().getPowers(), "AUTOMATON");
				if (auto.getSelectedOption().getXMLID().toUpperCase()
						.startsWith("NOSTUN")) {
					total = total * auto.getDefenseCostMultiplier();
				}
			}
		}
		return total;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		if ((getOptions().size() == 0)
				&& (GenericObject.findObjectByID(getAvailableAdders(),
						"HOWWELL") != null)
				&& (GenericObject.findObjectByID(getAvailableAdders(),
						"HOWWIDE") != null)) {
			Adder howWell = (Adder) GenericObject.findObjectByID(
					getAvailableAdders(), "HOWWELL");
			if (GenericObject.findObjectByID(getAssignedAdders(), "HOWWELL") != null) {
				howWell = (Adder) GenericObject.findObjectByID(
						getAssignedAdders(), "HOWWELL");
			} else {
				getAssignedAdders().add(howWell);
			}
			GenericObject howWide = GenericObject.findObjectByID(
					getAvailableAdders(), "HOWWIDE");
			if (GenericObject.findObjectByID(getAssignedAdders(), "HOWWIDE") != null) {
				howWide = GenericObject.findObjectByID(getAssignedAdders(),
						"HOWWIDE");
			} else {
				getAssignedAdders().add((Adder) howWide);
			}
			// this is a v2 Reputation instance....check if save file is v1 and
			// convert if necessary:
			String check = XMLUtility.getValue(root, "OPTIONID");
			String alias = XMLUtility.getValue(root, "OPTION_ALIAS");
			String alias1 = alias;
			String alias2 = "";
			if (alias.indexOf(";") > 0) {
				alias1 = alias.substring(0, alias.lastIndexOf(";"));
				alias2 = alias
						.substring(alias.lastIndexOf(";"), alias.length());
			} else if (alias.indexOf(",") > 0) {
				alias1 = alias.substring(0, alias.lastIndexOf(","));
				alias2 = alias
						.substring(alias.lastIndexOf(","), alias.length());
			}
			if ((check != null) && (check.trim().length() > 0)) {
				for (Adder op : howWide.getOptions()) {
					if (check.startsWith(op.getXMLID())) {
						op.setAlias(alias1);
						howWide.setSelectedOption(op);
						break;
					}
				}
				for (Adder op : howWell.getOptions()) {
					if (check.endsWith(op.getXMLID())) {
						op.setAlias(alias2);
						howWell.setSelectedOption(op);
						break;
					}
				}
			} else { // match the displays
				check = XMLUtility.getValue(root, "OPTION");
				if ((check != null) && (check.trim().length() > 0)) {
					for (Adder op : howWide.getOptions()) {
						if (check.startsWith(op.getDisplay())) {
							op.setAlias(alias1);
							howWide.setSelectedOption(op);
							break;
						}
					}
					for (Adder op : howWell.getOptions()) {
						if (check.endsWith(op.getDisplay())) {
							op.setAlias(alias2);
							howWell.setSelectedOption(op);
							break;
						}
					}
				}
			}
		}
	}
}